import 'package:flutter/material.dart';
import 'package:nb_utils/nb_utils.dart';

import '../utils/colors.dart';
import 'cached_image_widget.dart';

class CustomIconButton extends StatelessWidget {
  final bool isTrue;
  final String icon;
  final String checkIcon;
  final Color? color;
  final Function() onTap;
  final double iconHeight;
  final double iconWidth;
  final EdgeInsets? padding;
  final Color? buttonColor;
  final double buttonHeight;
  final double buttonWidth;

  final Color? iconColor;
  final Icon? iconWidget;

  const CustomIconButton({
    super.key,
    required this.icon,
    required this.onTap,
    this.isTrue = false,
    this.checkIcon = "",
    this.color,
    this.iconHeight = 22,
    this.iconWidth = 22,
    this.padding,
    this.buttonColor,
    this.buttonWidth = 22,
    this.buttonHeight = 22,
    this.iconWidget,
    this.iconColor,
  });

  @override
  Widget build(BuildContext context) {
    return IconButton(
      splashColor: splashColor,
      onPressed: onTap,
      color: isTrue ? appColorPrimary : buttonColor ?? circleColor,
      padding: padding ?? EdgeInsets.all(18),
      autofocus: true,
      style: ButtonStyle(
        overlayColor: WidgetStatePropertyAll(splashColor),
        visualDensity: VisualDensity.standard,
        tapTargetSize: MaterialTapTargetSize.padded,
        surfaceTintColor: WidgetStatePropertyAll(buttonColor),
        backgroundColor: WidgetStatePropertyAll(buttonColor),
      ),
      icon: iconWidget ??
          CachedImageWidget(
            url: isTrue
                ? checkIcon.isNotEmpty
                    ? checkIcon
                    : icon
                : icon,
            height: iconHeight,
            width: iconWidth,
            color: iconColor ?? (isTrue ? appColorPrimary : white),
            fit: BoxFit.cover,
          ),
    );
  }
}